/************************************************************************
 * NAME:	fileio.h
 *
 * DESCR:	file io includables
 *
 *
 * NOTES:	
 ************************************************************************/

struct hdosfs;

struct hdos_file {
    struct hdosfs *hdosfs;	/* pointer back to the file system	*/
    int		 inuse;		/* TRUE if in use, FALSE otherwise	*/
    hdos_inode	 inode;		/* the inode of the open file		*/
    char	*buffer;	/* stores a group (alloc'd during init)	*/
    int		 bufsize;	/* size (in bytes) of buffer		*/
    int		 firstgrp;	/* first group where this file is	*/
    int		 lastgrp;	/* first group where this file is	*/
    int		 curgrp;	/* current group in buffer (0 if none)	*/
    int		 cursize;	/* current size of data in buffer	*/
    int		 curgrp_no;	/* which ordinal group of file is this	*/
    int		 lastsectors;	/* number of sectors in last group	*/
    int		 cursor;	/* byte position within buffer		*/
                                /* points to NEXT byte to be consumed	*/
    int		 writemode;	/* TRUE if writing			*/
};

extern int hdos_file_flush(struct hdos_file *);
extern struct hdos_file *hdos_file_open(struct hdosfs *, char *);
extern struct hdos_file *hdos_file_new(struct hdosfs *, char *);
extern void hdos_file_close(struct hdos_file *);
